 ; Ŀ
 ;   99: plot from data stored in the block 99.                            
 ;   Copyright 1991, 2006 by Rocket Software Ltd.                          
 ;   Yeah, I know, you thought of that years ago.                          
 ; 

 ; Ŀ
 ;   Subroutine Croco - draw a temporary marker.                           
 ; 
 (DEFUN CROCO (pa / blip colo colo2 rad rad2)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq colo 140)
  (setq colo2 170)
  (setq rad (/ (getvar "viewsize") 35))
  (setq rad2 (/ (getvar "viewsize") 45))
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (/ pi 2) rad) (polar pa (* 1.5 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
  (grdraw (polar pa 0 rad) (polar pa pi rad) colo)
  (grdraw (polar pa (/ pi 8) rad2) (polar pa (* 1.125 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.375) rad2) (polar pa (* 1.375 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.625) rad2) (polar pa (* 1.625 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.875) rad2) (polar pa (* 1.875 pi) rad2) colo2)
  (grdraw (polar pa 0 rad2) (polar pa pi rad2) colo2)
  (grdraw (polar pa (/ pi 2) rad2) (polar pa (* 1.5 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.75) (* rad 0.75))
          (polar pa (* pi 1.75) (* rad 0.75)) colo2)
  (grdraw (polar pa (* pi 0.25) (* rad 0.75))
          (polar pa (* pi 1.25) (* rad 0.75)) colo2)
  (setvar "blipmode" blip)
 (princ))
 ; Ŀ
 ;   Croco end.                                                            
 ; 

 ; Ŀ
 ;   Fipb - find the plot data block.  Or blocks.                          
 ;   Arguments: Blnam, a block name.                                       
 ;   Calls nothing.                                                        
 ;   Returns a list of lists: ((tab insertion value value ...) ...)        
 ; 
 (DEFUN FIPB (blnam / ss num enam entt plist malist)
  (if (setq ss (ssget "x" (list (cons 2 blnam))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
 ; Ŀ
 ;   Find the tab containing the block and its insertion point.            
 ; 
                  (setq entt (entget enam))
                  (setq plist (list (cdr (assoc 410 entt))
                                    (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Extract the plot parameters.                                          
 ; 
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt
                                       (entget (setq enam (entnext enam)))))))
                         (setq plist (append plist (list (cdr
                                                          (assoc 1 entt))))))
                  (setq malist (cons plist malist)))))
 malist)
 ; Ŀ
 ;   Fipb end.                                                             
 ; 

 ; Ŀ
 ;   99.                                                                   
 ; 
 (DEFUN C:99 (/ num malist sub tabnam spaca subnum str)
  (setvar "cmdecho" 0)
  (setq num 0)
  (if (null (setq malist (fipb "99")))
      (prompt "No data block available.")
 ; Ŀ
 ;   Run a plot for each sublist in malist.                                
 ; 
      (while (setq sub (nth num malist))
             (setq num (1+ num))
 ; Ŀ
 ;   See which space each title block occupies, go to that space.          
 ; 
             (setvar "ctab" (setq tabnam (car sub)))
             (if (= (strcase tabnam t) "model")
                 (setq spaca "ms")
                 (progn
                      (setq spaca "ps")
                      (command ".pspace")))
             (croco (cadr sub))
             (setq sub (cdddr sub))  ; ditch tab name, insertion, first attrib.
 ; Ŀ
 ;   Start the plot command.                                               
 ; 
             (command "-plot")
             (command "y")     ; Detailed plot configuration? [Yes/No] <No>:
             (command "")      ; plot whatever tab we are in.
 ; Ŀ
 ;   Decide which values not to use depending on whether the block is      
 ;   in the model tab or in a layout tab (paper space).                    
 ; 
             (setq subnum 0)
             (while (setq str (nth subnum sub))
                    (setq subnum (1+ subnum))
                    (if (or (and (= spaca "ms")
                                 (not (member subnum '(13 14 15))))
                            (and (= spaca "ps")
                                 (not (member subnum '(12)))))
                        (command str)))))
 (princ))